#!/usr/bin/perl

# ----------------------------------------------------------------------------
# program:	makehtml.pl
# version:	0.05 - build 1999-11-05
# task:		Creates HTML documents out of a simple script and some
#		dummy and content files
# author:	Jan Theofel, jan@theofel.de
# language:	Perl
# license:	GPL (GNU General Public License)
# ----------------------------------------------------------------------------
# THIS PROGRAM IS PUBLISHED UNDER THE TERMS OF THE GNU PUBLIC LICENSE (GPL).
# IT COMES WITH ABSOLUTLY NO WARRENTY! USE IT AT YOUR OWN RISK!
# ----------------------------------------------------------------------------

use GD;

$identify = "makehtml v0.05 build 1999-11-05 by Jan Theofel (jan\@theofel.de)";

&init;
&run;
&done;

sub init
# ----------------------------------------------------------------------------
# sub: 		init
# task: 	initalisation of the script, reading & parsing input files
# author:	Jan Theofel, jan@theofel.de
# last changed: 1999-09-29
# ----------------------------------------------------------------------------
{
  &basic_init;
  &prepare_logfile;
  &parse_files; 
  &setgfxsize;
  &preparse;
  $relgfxpath = $set{RELGFXPATH};
} #--------------- end of sub init --------------- 

sub run
# ----------------------------------------------------------------------------
# sub:		run
# task:		creates the html files
# author:	Jan Theofel, jan@theofel.de
# last changed: 1999-10-27
# ----------------------------------------------------------------------------
{
  msg("----- Creating the homepage:\n");
  msg("writing files from the menu...\n");
  for($x=0;$x<=$#menuitems;$x++)
  {
    $x++;
    $filename = $menuitems[$x];
    $outfilename = $filename;
    open(OUT,">$filename")||die("FATAL ERROR: Can't open outfile $filename");
    $x++;
    $contentfile = $menuitems[$x];
    open(CONTENT,"<$contentfile")||die("FATAL ERROR: Can't open content file $content");
    $x++;
    $gfxfile = $menuitems[$x];
    $x++;
    $gfxhlfile = $menuitems[$x];
    $x++;
    $gfxhl2file = $menuitems[$x];
    $x++;
    $alttext = $menuitems[$x];
    $x++;
    $height = $menuitems[$x];
    $x++;
    $width = $menuitems[$x];

    $menu = "";
    $count_gfx = $set{START_COUNT_GFX};

    &create_menu($x);

    &start_html;

    &include_dummy;
  }
  msg("writing files which are not in the menu...\n");
  for($x=0;$x<=$#none_menu_files;$x++)
  {
    $filename = $none_menu_files[$x];
    open(OUT,">$filename")||die("FATAL ERROR: Can't open outfile $filename");
    $x++;
    $contentfile = $none_menu_files[$x];
    open(CONTENT,"<$contentfile")||die("FATAL ERROR: Can't open content file $contentfile");
    $menu = "";
    $count_gfx = $set{START_COUNT_GFX};

    &create_menu("none");

    &start_html;

    &include_dummy;
  }

}

sub done	# ------------------------------------------------------------
{		# quits the script
		# ------------------------------------------------------------

  msg("TOTAL WARNINGS: $warnings\n");
  msg("----- Homepage finished!!!\n");
  close(LOG);
}

sub usage	# ------------------------------------------------------------
{		# prints the usage to the screen and dies
		# ------------------------------------------------------------

  die <<EOF;
Usage:
  makehtml makefile
EOF
}

sub basic_init	# ------------------------------------------------------------
{		# makes the basic initalisations
		# ------------------------------------------------------------
  
  print "$identify\n\n";
  print "THIS PROGRAM IS PUBLISHED UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICNESE.\n";
  print "IT COMES WIT ABSOLUTLY NO WARRENTY. USE IT AT YOUR OWN RISK!\n\n";

  $paramcount = $#ARGV;
  if($paramcount==-1) {&usage};

  $warnings = 0;

  $submenu = 0;
  $javascriptdefs = 0;
  $fontdefs = 0;
  $defimages = ();
  %deftables = ();
  %menuitems = ();
  %imagemapdef = ();
  @addjavascript = ();
  @none_menu_files = ();

  push(@makefiles,$ARGV[0]);
}

sub setgfxsize	# -------------------------------------------------------------
{		# sets the size for the images, autodetection if needed
		# -------------------------------------------------------------

  msg("----- Preparing the homepage creation:\n");
  if($set{DUMMYHEIGHT}==0||$set{DUMMYHEIGHT}==undef||$set{DUMMYWIDTH}==0||$set{DUMMYWIDTH}==undef)
  {
    msg("Autodetecting size for dummy gfx...\n");
    $localfilename = $set{RELGFXPATH} . $set{GFXDUMMY};
    if(open(GIF,$localfilename)==0)
    {
      msg("Can't open $localfilename (dummy gfx), no autosize possible!\n");
    }
    else
    {
      if(($giffile = newFromGif GD::Image(GIF))=0)
      {
        warning("Dummy file is not a GIF file. Autodetection not possible!\n");
        $dummy_height = undef;
        $dummy_width = undef;
      }
      else
      {
        ($dummy_width,$dummy_height) = GD::Image::getBounds($giffile);
        msg("autosize (dummy gfx) returns width = $dummy_width, height = $dummy_height\n");
      }
    }
  }
  else
  {
    $dummy_height = $set{DUMMYHEIGHT}; $dummy_height =~ s/\s*//g;
    $dummy_width = $set{DUMMYWIDTH}; $dummy_width =~ s/\s*//g;
  }
}

sub parse_files	# -------------------------------------------------------------
{		# Parsing the makefiles
		# -------------------------------------------------------------
  msg("----- Parsing files\n");
  while($#makefiles!=-1)
  {
    $actual_makefile = pop(@makefiles);

    logmsg("Parsing file $actual_makefile ...\n");

    open(MAKE,"$actual_makefile")||die("FATAL ERROR: Can't open file $actual_makefile!\n\n");    $linecount = 0;

    while(<MAKE>)
    {
      $linecount++;
      chomp;
      if(/^$/) {next;}
      if(/^#.*$/){next;}
      $_=~s/^\s*//;

      ($command, $param, $value) =split(/\ /,$_,3);
      if(uc($command) eq "SET")
      {
        $set{uc($param)} = $value;
      }
      elsif(uc($command) eq "META")
      {
        $meta{$param} = $value;
      }
      elsif(uc($command) eq "FILE")
      {
        push(@none_menu_files,$param);
        push(@none_menu_files,$value);
      }
      elsif(uc($command) eq "MENUITEM")
      {
        push(@menuitems,"menuitem");                    # for menuitem
        push(@menuitems,$param);                        # filename
        @menuitem_attributs = split(/\ /,$value);       # content, button,
                                                        # button_hl, alttext
        push(@menuitems, @menuitem_attributs);
        if($#menuitem_attributs==4)
        {
          if($set{WIDTH}==undef)
          {
            push(@menuitems,0);
          }
          else
          {
            push(@menuitems,$set{WIDTH});
          }
          if($set{HEIGHT}==undef)
          {
            push(@menuitems,0);
          }
          else
          {
            push(@menuitems,$set{HEIGHT});
          }
        }
      }
      elsif(uc($command) eq "SUBMENU")
      {
        $submenu++;
        push(@menuitems,$submenu);
        push(@menuitems,$param);
        @menuitem_attributs = split(/\ /,$value);
        push(@menuitems, @menuitem_attributs);
        if($#menuitem_attributs==4)
        {
          if($set{WIDTH}==undef)
          {
            push(@menuitems,0);
          }
          else
          {
            push(@menuitems,$set{WIDTH});
          }
          if($set{HEIGHT}==undef)
          {
            push(@menuitems,0);
          }
          else
          {
            push(@menuitems,$set{HEIGHT});
          }
        }
      }
      elsif(uc($command) eq "SUBMENUITEM")
      {
      }
      elsif(uc($command) eq "IMG")
      {
        push(@defimages, uc($param), $value);
      }
      elsif(uc($command) eq "DEFTABLE")
      {
        %localdef = ();
        $startdefline = $linecount;
        $enddef = 0;
        while(<MAKE>)
        {
          $linecount++;
          chomp;
          if(/^$/) {next;}
          if(/^#.*$/){next;}
          $_=~s/^\s*//;
          if($_ eq "enddef") { $enddef = 1; last; }
          ($param, $value) =split(/\ /,$_,2);
          $param =~ s/^\s+//;
          $param =~ s/\s+$//;
          $value =~ s/^\s+//;
          $value =~ s/\s+$//;
          $localdef{uc($param)} = $value;
        }
        if($enddef==0)
        {
          close(MAKE);
          die("FATAL ERROR: Missing enddef for def in line $startdefline!");
        }
        elsif($localdef{NAME} eq "")
        {
          close(MAKE);
          die("FATAL ERROR: Missing name for def from line $startdefline to $linecount!");
        }
        else
        {
          logmsg("reading table definition $localdef{NAME}\n");
        }
        foreach $_ (keys(%localdef))
        {
          $name = $localdef{NAME} . "_" . uc($_);
          $deftables{$name} = $localdef{$_};
        }
      }
      elsif(uc($command) eq "DEFJAVASCRIPTGFX")
      {
        $javascriptdefs++;
        $startdefline = $linecount;
        $enddef = 0;
        while(<MAKE>)
        {
          $linecount++;
          chomp;
          if(/^$/) {next;}
          if(/^#.*$/){next;}
          $_=~s/^\s*//;
          if($_ eq "enddef") { $enddef = 1; last; }
          ($param, $value) =split(/\ /,$_,2);
          $javascriptgfxdef{$javascriptdefs . $param} = $value;
        }
        if($enddef==0)
        {
          close(MAKE);
          die("FATAL ERROR: Missing enddef for javascript gfx addition in line $startdefline!");
        }
        else
        {
           msg("reading graphics for adding to java script (jsgfx #$javascriptdefs)\n");
        }
      }
      elsif(uc($command) eq "DEFFONT")
      {
        $fontdefs++;
        $startdefline = $linecount;
        $enddef = 0;
        while(<MAKE>)
        {
          $linecount++;
          chomp;
          if(/^$/) {next;}
          if(/^#.*$/){next;}
          $_=~s/^\s*//;
          if($_ eq "enddef") { $enddef = 1; last; }
          ($param, $value) =split(/\ /,$_,2);
          $fontdef{uc($fontdefs . $param)} = $value;
        }
        if($enddef==0)
        {
          close(MAKE);
          die("FATAL ERROR: Missing enddef for javascript gfx addition in line $startdefline!");
        }
        logmsg("reading font definition " . $fontdef{$fontdefs . "NAME"} . "\n");
      }
      elsif(uc($command) eq "INCLUDE")
      {
        logmsg("storing file $param in include stack\n");
        push(@makefiles,$param);
      }
      elsif(uc($command) eq "JAVASCRIPT")
      {
        msg("reading javascript code starting in line $linecount...\n");
        $startjavascript = $linecount;
        $javascriptended = 0;
        while(<MAKE>)
        {
          if(uc($_) =~ /\s*ENDJAVASCRIPT\s*/)
          {
            $javascriptended = 1;
            last;
          }
          else
          {
            push(@addjavascript,$_);
          }
        }
        if($javascriptended==0)
        {
          die("FATAL ERROR: Javascript code from line $startjavascript has no end!\n             Use command 'endjavascript' to end it correctly.\n");
        }
      }
      elsif(uc($command) =~ /\s*IMAGEMAP\s*/)
      {
        $imagemapname = "";
        $imagemapdata = "";
        $startdefline = $linecount;
        $enddef = 0;
        while(<MAKE>)
        {
          $linecount++;
          chomp;
          if(/^$/) {next;}
          if(/^#.*$/){next;}
          $_=~s/^\s*//;
          if(uc($_) =~ /\s*ENDIMAGEMAP\s*/)
            { $enddef = 1; last; }
          ($kind, $link, $data, $alt) =split(/\ /,$_,4);
          if(uc($kind) eq "NAME") 
            { $imagemapname = $link; } 
          else
          {
            @coords = (); 
            @coords = split(/,/,$data);
            for($count_coords=0;$count_coords<=$#coords;$count_coords++)
            {
              if($coords[$count_coords] =~ /^\+(.*)$/)
                { $coords[$count_coords] = $coords[$count_coords-2] + $1; } 
              if($coords[$count_coords] =~ /^-(.*)$/)
                { $coords[$count_coords] = $coords[$count_coords-2] - $1; }
            }
            $coords = join(",",@coords);
            $imagemapdata = $imagemapdata . "<AREA SHAPE=\"" . uc($kind) . "\" COORDS=\"$coords\" HREF=\"$link\" ALT=\"$alt\">\n";
          }
        }
        if($imagemapname eq "")
          { die("FATAL ERROR: Missing name for imagemap definition in line $startdefline!"); }
        if($enddef==0)
        {
          close(MAKE);
          die("FATAL ERROR: Missing enddef for imagemap definition in line $startdefline!");
        }
#!!!        msg("reading imagemap definition " . $fontdef{$fontdefs . "NAME"} . "\n");

        $imagemapdata = "<MAP NAME=\"$imagemapname\">\n" . $imagemapdata . "<\/MAP>\n";

        $imagemapdef{$imagemapname} = $imagemapdata;

      }
      else
      {
        close(MAKE);
        die "FATAL ERROR: Error reading line $linecount!\n\n";
      }
    }
    close(MAKE);
  }
}

sub create_menu_gfx_entries	# ---------------------------------------------
{				# prints the entries in the java script which
				# are needed for the menu
				# ---------------------------------------------

    $js_gfx_count = 0;
    for($js=0;$js<=$#menuitems;$js++)
    {
      $js+=3;
      $js_gfxfile = $menuitems[$js];
      $js+=5;
      print OUT "    menuitem$js_gfx_count = new Image();\n";
      print OUT "    menuitem$js_gfx_count.src = \"$js_gfxfile\";\n";
      $js_gfx_count++;
    }
    $js_gfx_count = 0;
    for($js=0;$js<=$#menuitems;$js++)
    {
      $js+=5;
      $js_gfxhl2file = $menuitems[$js];
      $js+=3;
      print OUT "    menuitem".$js_gfx_count."_hl = new Image();\n";
      print OUT "    menuitem".$js_gfx_count."_hl.src = \"$js_gfxhl2file\";\n";
      $js_gfx_count++;
    }

}

sub create_add_gfx_entries	# ---------------------------------------------
{				# insert additional items in the js list
				# ---------------------------------------------
  if($javascriptdefs!=0)
  {
    for($count=1;$count<=$javascriptdefs;$count++)
    {
      if($javascriptgfxdef{$count . "files"} =~ /$outfilename/)
      {
        msg("  Adding graphic entries to javascript for file $outfilename (jsgfx #$count)\n");
        print OUT "\n";
        $filenamemask = $javascriptgfxdef{$count . "filename"};
        foreach $key (keys(%javascriptgfxdef))
        {
          if(uc($key) ne $count."FILES" && uc($key) ne $count."FILENAME")
          {
            if($key !~ /^$count/)
            {
              next;
            }
            $key =~ s/^$count//;
            $gfxfilename = $filenamemask;
            $gfxfilename =~ s/\*/$javascriptgfxdef{$count.$key}/; 
            print OUT "    $key = new Image();\n";
            print OUT "    $key.src = \"$gfxfilename\";\n";
          } 
        }
      }
      else
      {
        logmsg("  No additional grapic entries to javascript for file $outfilename (jsgfx #$count)\n");
      }
    }
  }
}

sub create_add_javascriptcode	# ---------------------------------------------
{				# inserts additionaly javascript code form the
				# makefile(s)
				# ---------------------------------------------

  if($#addjavascript!=-1)
  {
    logmsg("  Adding javascript code from makefile...\n");
    print OUT "\n";
    for($count=0;$count<=$#addjavascript;$count++)
    {
      print OUT $addjavascript[$count];
    }
  }

}

sub preparse
# -----------------------------------------------------------------------------
# sub:		preparse
# task:		setting some values from the makefiles for faster access to
# 		them, preparsing of the meta tags
# author:	Jan Theofel, jan@theofel.de
# last changed:	1999-10-27 by Jan Theofel
# ----------------------------------------------------------------------------
{

# ----- read in some vars for faster access to them -----
  $relgfxpath = $set{RELGFXPATH};
  $menuhorizontal = (uc($set{MENU}) =~ /HORIZONTAL/);
  if($menuhorizontal)
  {
    msg("Using horizontal menus!\n");
  }
  else
  {
    msg("Using vertical menus!\n");
  }

# ----- preparse the meta tags (references on others) -----
  foreach $key (keys(%meta))
  {
    if($meta{$key} =~ /^=/)
    {
      $newkey = $meta{$key};
      $newkey =~ s/^=//;
      $meta{$key} = $meta{$newkey};
    }
  }

# ----- print out the used meta tags ----- 
  logmsg("Using the following meta-tags:\n");
  foreach $key(keys(%meta))
  {
    logmsg("  $key -> $meta{$key}\n");
  }

# ----- preparsing of the menu items -----
  msg("preparing menuitems...\n");
# --- some analisis of the menuitems ---
  for($x=0;$x<=$#menuitems;$x++)
  {
    $x+=3;
    $basefilename = $menuitems[$x];
    $gfxfilename = $set{GFXFILENAME};
    $gfxfilename =~ s/\*/$menuitems[$x]/;
    $menuitems[$x]=$gfxfilename;

    $x++;
    if($menuitems[$x] eq "*")
    {
      $menuitems[$x] = $basefilename;
    }
    $gfxhlfilename = $set{GFXHLFILENAME};
    $gfxhlfilename =~ s/\*/$menuitems[$x]/;
    $menuitems[$x]=$gfxhlfilename;

    $x++;
    if($menuitems[$x] eq "*")
    {
      $menuitems[$x] = $basefilename;
    }
    $gfxhl2filename = $set{GFXHL2FILENAME};
    $gfxhl2filename =~ s/\*/$menuitems[$x]/;
    $menuitems[$x]=$gfxhl2filename;

    $x++;

    $localfilename = $set{RELGFXPATH} . $gfxhlfilename;
    if(open(GIF,$localfilename)==0)
    {
      msg("  Can't open $localfilename, no autosize possible!\n");
      $x+=2;
    }
    else
    {
      $giffile = newFromGif GD::Image(GIF);
      ($file_width,$file_height) = GD::Image::getBounds($giffile);
      logmsg("  autosize returns width = $file_width, height = $file_height\n");

      $x++;
      if($menuitems[$x] == 0)
      {
        $menuitems[$x] = $file_width;
      }

      $x++;
      if($menuitems[$x] == 0)
      {
        $menuitems[$x] = $file_height;
      }

      close(GIF);
    }
  }

# ----- checking the dummy gfx file -----
  if(!-e $set{DUMMY}) { die "FATAL ERROR: dummy file $set{DUMMY} not found!"; }

} # --------------- end of sub preparse ---------------

sub menu_direction	# -----------------------------------------------------
{			# inserts a <br> if the menu is vertical
			# -----------------------------------------------------

  if(!$menuhorizontal)
  {
    $menu = $menu . "<br>";
  }
}

sub start_html
# ----------------------------------------------------------------------------
# sub:		start_html
# task:		creates the HTML header with doctype, head, meta tags, java-
#		script
# author:	Jan Theofel, jan@theofel.de
# last changed:	1999-10-27 by Jan Theofel
# ----------------------------------------------------------------------------
{

# ----- create the html head with meta tags -----
  print OUT "<!DOCTYPE HTML PUBLIC \"-\/\/W3C\/\/DTD HTML $set{HTML}\/\/EN\">\n";
  print OUT "\n<HTMl>\n\n<HEAD>\n";
  print OUT "  <TITLE>$set{TITLE}<\/TITLE>\n";

  foreach $key (keys(%meta))
  {
    print OUT "  <META TYPE=\"$key\" CONTENT=\"".$meta{$key}."\">\n";
  }

# ----- create the java script for the menu -----
  print OUT "  <SCRIPT LANGUAGE=\"JavaScript\">\n  <!--\n\n";

  &create_menu_gfx_entries;

  &create_add_gfx_entries;

  &create_add_javascriptcode;

# ----- now print out the rest for the java script -----
  print OUT <<JAVASCRIPT;

  function ChangeGFX(gfxid,gfx)
  {
   window.document.images[gfxid].src = gfx.src;
  }
 //-->
  //-->
 </script>
</head>

JAVASCRIPT

# ----- increase the gfx counter -----
  $count_gfx = $count_gfx + $set{ADD_COUNT_GFX};

}

sub include_dummy
# ----------------------------------------------------------------------------
# sub:          include_dummy 
# task:         includes the dummy html files and replaces the needed parts
# author:       Jan Theofel, jan@theofel.de
# last changed: 1999-11-02 by Jan Theofel
# ----------------------------------------------------------------------------
{
  @table_in_use = ();
  open(DUMMY,"<$set{DUMMY}");
  while(<DUMMY>)
  {
    if(/\<\!--menu--\>/i)
    {
      ($before,$after) = split(/\<\!--menu--\>/i);
      print OUT "$before$menu$after";
    }
    elsif(/\<\!--content--\>/i)
    {
      ($before,$after) = split(/\<\!--content--\>/i);
      @table_in_use = ();
      print OUT $before;
      while(<CONTENT>)
      {
        $line = $_;
        if($line=~/\<img/i)
        {
          $count_gfx++;
        }
        if($line=~/\<\!--img\:(\w*)--\>/i)
        {
          $imgname = uc($1);
          $foundimg = -1;
          for($count=0;$count<=$#defimages;$count+=2)
            { if($defimages[$count] eq $imgname) { $foundimg = $count; } }
          if($foundimg == -1)
          {
            warning("Image '$1' not found in makefile!\n");
          }
          else
          {
            $foundimg++;
            $line=~s/\<\!--img\:$1--\>/$defimages[$foundimg]/i;
            $count_gfx++;
            logmsg("Image '$1' used in file $outfilename.\n");
          }
        }
        if($line=~/\<\!--starttable\:(\w*)--\>/i)
        {
          $callername = $1;
          logmsg("  Using table definition $1 in file $outfilename\n");
          push(@table_in_use, $1);
          $active_table_name = $1;
          $table_tag = "<TABLE";
          if($deftables{$active_table_name . "_BORDER"} ne "")
          {
            $table_tag = $table_tag . " BORDER=\"" . $deftables{$active_table_name . "_BORDER"} . "\"";
          }
          if($deftables{$active_table_name . "_CELLSPACING"} ne "")
          {
            $table_tag = $table_tag . " CELLSPACING=\"" . $deftables{$active_table_name . "_CELLSPACING"} . "\"";
          }
          if($deftables{$active_table_name . "_CELLPADDING"} ne "")
          {
            $table_tag = $table_tag . " CELLPADDING=\"" . $deftables{$active_table_name . "_CELLPADDING"} . "\"";
          }
          if($deftables{$active_table_name . "_WIDTH"} ne "")
          {
            $table_tag = $table_tag . " WIDTH=\"" . $deftables{$active_table_name . "_WIDTH"} . "\"";
            }
          if($deftables{$active_table_name . "_HEIGHT"} ne "")
          {
            $table_tag = $table_tag . " HEIGHT=\"" . $deftables{$active_table_name . "_HEIGHT"} . "\"";
          }
          $table_tag = $table_tag . ">";
          $line=~s/\<\!--starttable\:$callername--\>/$table_tag/i;
        }
        if($line=~/\<\!--endtable\:(\w*)--\>/i)
        {
          $callername = $1;
          $line=~s/\<\!--endtable\:$callername--\>/\<\/TABLE\>/i;
          $ret = pop(@table_in_use);
          if($ret ne $callername)
          {
            if($ret eq "")
            {
              warning("Table end found which has no start ('$callername')!\n");
            }
            else 
            {
              warning("Table '$ret' ended by '$callername'!\n");
            }
          }
        }
        if($#table_in_use!=i-1)       # if some table definition is active
        {
          if($line=~/\<td([^\>]*)\>/i)
          {
            $td_tag = "<TD$1";
            $td_tag = $td_tag . ">";
            $line =~ s/\<td[^\>]*\>/$td_tag$deftables{$active_table_name."_TDSTART"}/;
          }
          if($line=~/\<\/td\>/i)
          {
            $line =~ s/\<\/td\>/$deftables{$active_table_name."_TDEND"}\<\/TD\>/;
          }
        }

        if($line=~/\<\!--startfont\:(\w*)--\>/i)
        {
          logmsg("Using font definition $1 in file $outfilename\n");
          push(@font_in_use, $1);
          $active_font_name = $1;
          $font_found = 0;
          for($count=1;$count<=$fontdefs;$count++)
          {
            if($fontdef{$count . "NAME"} eq $active_font_name)
            {
              $replace_tag = $fontdef{$count . "START"};
              $line=~s/\<\!--startfont\:$active_font_name--\>/$replace_tag/i;
              $font_found = 1;
              last;
            }
          }
          if($font_found == 0)
          {
            warning("Font $active_font_name not found in makefiles!\n");
          }
        }
        if($line=~/\<\!--endfont\:(\w*)--\>/i) 
        {
          $ret = pop(@font_in_use);
          if($ret ne $1)
          {
            if($ret eq "")
            {
              warning("Font end found which has no start ('$1')!\n");
            }
            else
            {
              warning("Font '$ret' ended by '$1'\"!\n");
            }
          }
          for($count=1;$count<=$fontdefs;$count++)
          {
            if($fontdef{$count . "NAME"} eq $active_font_name)
            {
              $replace_tag = $fontdef{$count . "END"};
              $line=~s/\<\!--endfont\:$ret--\>/$replace_tag/i;
              last;
            }
          }
        }

        if($line=~/\<\!--highlight\:([\w,]*)--\>/i)
        {
          ($highlight_gfx,$normal_gfx) = split(/,/,$1);
          $highlightcommand = " onMouseOver=\"ChangeGFX($count_gfx,$normal_gfx);\" onMouseOut=\"ChangeGFX($count_gfx,$highlight_gfx);\"";
          $line=~s/\<\!--highlight\:([\w,]*)--\>/$highlightcommand/i;
        }
        if($line=~/\<\!--imagemap\:(\w*)--\>/i)
        {
          $imagemapname = $1;
          if($imagemapdef{$imagemapname} eq undef)
            { die "FATAL ERROR: Imagemap $imagemapname undefined!\n"; }
          $line=~s/\<\!--imagemap\:$imagemapname--\>/ ismap usemap=\"\#$imagemapname\" /i;
          $line = $line . $imagemapdef{$imagemapname};
        }
        print OUT $line;
      }
      print OUT $after;
    }
    else
    {
      print OUT;
    }
  }
  close(CONTENT)||die("FATAL ERROR: Can't close content file $content");
  close(OUT)||die("FATAL ERROR: Can't close outfile $filename");
}

sub create_menu
# ----------------------------------------------------------------------------
# sub:		create_menu
# task:		creates the clickable menu depending on the file which is
#		actually created
# author:	Jan Theofel, jan@theofel.de
# last changed:	1999-10-30 by Jan Theofel
# parameters:	1: actual menu item id
# ----------------------------------------------------------------------------
{
  $menuitem = 0;
  for($y=0;$y<=$#menuitems;$y++)
  {
    $y++;
    $filename = $menuitems[$y];
    $y+=2;
    $gfxfile = $menuitems[$y];
    $y++;
    $gfxhlfile = $menuitems[$y];
    $y++;
    $gfxhl2file = $menuitems[$y];
    $y++;
    $alttext = $menuitems[$y];
    $y++;
    $width = $menuitems[$y];
    $y++;
    $height = $menuitems[$y];

      if($y==$_[0])
      {
        $menu = $menu . "<IMG SRC=\"$gfxhlfile\" BORDER=\"0\" ALT=\"$alttext\" WIDTH=\"$width\" HEIGHT=\"$height\">";
        $count_gfx++;
        &menu_direction;
      }
      else
      {
        $menu = $menu . "<A HREF=\"$filename\" onMouseOver=\"ChangeGFX($count_gfx,menuitem".$menuitem."_hl);\" onMouseOut=\"ChangeGFX($count_gfx,menuitem$menuitem);\"><img src=\"$gfxfile\" BORDER=\"0\" ALT=\"$alttext\" WIDTH=\"$width\" HEIGHT=\"$height\"><\/A>";
        $count_gfx++;
        &menu_direction;
      }
      $menu = $menu . "<IMG SRC=\"$set{GFXDUMMY}\" ALT=\"\"";
      if(!($dummyheight == undef))
        { $menu = $menu . "WIDTH=\"$dummy_width\""; }
      if(!($dummywidth == undef))
        {  $menu = $menu . " HEIGHT=\"$dummy_height\""; }
      $menu = $menu .  ">";
      &menu_direction;
      $count_gfx++;
      $menuitem++;
    }
}

sub prepare_logfile
# ----------------------------------------------------------------------------
# sub:          prepare_logfile
# task:         opens the logfile and checks for success 
# author:       Jan Theofel, jan@theofel.de
# last changed: 1999-11-02
# ----------------------------------------------------------------------------
{
  if(open(LOG,">homepage.log")!=0)
  {
    $logging = 1; 
    print LOG "logfile created the ... by:\n\n";
    print LOG "  $identify\n\n";
    print LOG "THIS PROGRAM IS PUBLISHED UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICNESE.\n";
    print LOG "IT COMES WITH ABSOLUTLY NO WARRENTY. USE IT AT YOUR OWN RISK!\n\n";
  }
  else
  {
    $logging = 0;
    $warnings++;
    print("WARNING: Can't open logfile - logging goes only to stdout.\n\n");
    # can't use 'warning' here as it wants to log
  }
}

sub msg 
# ----------------------------------------------------------------------------
# sub:          msg 
# task:         prints a string to the logfile and to STDOUT
# author:       Jan Theofel, jan@theofel.de
# last changed: 1999-11-02
# ----------------------------------------------------------------------------
{
  if($#_ == -1) { return; }
  if($logging) { print LOG $_[0]; }
  print $_[0];
}

sub logmsg
# ----------------------------------------------------------------------------
# sub:          logmsg
# task:         prints a string only to the logfile
# author:       Jan Theofel, jan@theofel.de
# last changed: 1999-11-02
# ----------------------------------------------------------------------------
{
  if($#_ == -1) { return; }
  if($logging) { print LOG $_[0]; }
}


sub warning
# ----------------------------------------------------------------------------
# sub:          warning
# task:         prints a string as warning
# author:       Jan Theofel, jan@theofel.de
# last changed: 1999-11-02
# ----------------------------------------------------------------------------
{
  $warnings++;
  msg("WARNING: $_[0]\n");
}
__END__
